package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbCheckTableStatement extends MariadbStatementImpl {
   private final List<SQLExprTableSource> tables = new ArrayList();
   private List<SQLExpr> identifiedList = new ArrayList();

   public void addTable(SQLExprTableSource table) {
      if (table != null) {
         table.setParent(this);
         this.tables.add(table);
      }
   }

   public List<SQLExprTableSource> getTables() {
      return this.tables;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tables);
      }

      visitor.endVisit(this);
   }

   public List<SQLExpr> getIdentifiedList() {
      return this.identifiedList;
   }

   public void setIdentifiedList(List<SQLExpr> identifiedList) {
      this.identifiedList = identifiedList;
   }
}
