package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLColumnDefinition;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbCreateFullTextDictionaryStatement extends MariadbStatementImpl implements MariadbShowStatement {
   private SQLName name;
   private SQLColumnDefinition column;
   private String comment;

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public SQLColumnDefinition getColumn() {
      return this.column;
   }

   public void setColumn(SQLColumnDefinition column) {
      this.column = column;
   }

   public String getComment() {
      return this.comment;
   }

   public void setComment(String comment) {
      this.comment = comment;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.column);
      }

      visitor.endVisit(this);
   }
}
