package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.dialect.mariadb.ast.MariadbObjectImpl;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbCreateUserStatement extends MariadbStatementImpl implements SQLCreateStatement {
   private List<UserSpecification> users = new ArrayList(2);
   private boolean ifNotExists = false;

   public List<UserSpecification> getUsers() {
      return this.users;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }

   public void addUser(UserSpecification user) {
      if (user != null) {
         user.setParent(this);
      }

      this.users.add(user);
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.users);
      }

      visitor.endVisit(this);
   }

   public static class UserSpecification extends MariadbObjectImpl {
      private SQLExpr user;
      private boolean passwordHash = false;
      private SQLExpr password;
      private SQLExpr authPlugin;
      private boolean pluginAs;

      public SQLExpr getUser() {
         return this.user;
      }

      public void setUser(SQLExpr user) {
         this.user = (SQLName)user;
      }

      public boolean isPasswordHash() {
         return this.passwordHash;
      }

      public void setPasswordHash(boolean passwordHash) {
         this.passwordHash = passwordHash;
      }

      public SQLExpr getPassword() {
         return this.password;
      }

      public void setPassword(SQLExpr password) {
         this.password = password;
      }

      public SQLExpr getAuthPlugin() {
         return this.authPlugin;
      }

      public void setAuthPlugin(SQLExpr authPlugin) {
         this.authPlugin = authPlugin;
      }

      public boolean isPluginAs() {
         return this.pluginAs;
      }

      public void setPluginAs(boolean pluginAs) {
         this.pluginAs = pluginAs;
      }

      public void accept0(MariadbASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.user);
            this.acceptChild(visitor, this.password);
            this.acceptChild(visitor, this.authPlugin);
         }

         visitor.endVisit(this);
      }
   }
}
