package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbExecuteForAdsStatement extends MariadbStatementImpl {
   private SQLName action;
   private SQLName role;
   private SQLCharExpr targetId;
   private SQLName status;

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.action);
         this.acceptChild(visitor, this.role);
         this.acceptChild(visitor, this.targetId);
         this.acceptChild(visitor, this.status);
      }

      visitor.endVisit(this);
   }

   public SQLName getAction() {
      return this.action;
   }

   public void setAction(SQLName action) {
      this.action = action;
   }

   public SQLName getRole() {
      return this.role;
   }

   public void setRole(SQLName role) {
      this.role = role;
   }

   public SQLCharExpr getTargetId() {
      return this.targetId;
   }

   public void setTargetId(SQLCharExpr targetId) {
      this.targetId = targetId;
   }

   public SQLName getStatus() {
      return this.status;
   }

   public void setStatus(SQLName status) {
      this.status = status;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.action != null) {
         children.add(this.action);
      }

      if (this.role != null) {
         children.add(this.role);
      }

      if (this.targetId != null) {
         children.add(this.targetId);
      }

      if (this.status != null) {
         children.add(this.status);
      }

      return children;
   }
}
