package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbExecuteStatement extends MariadbStatementImpl {
   private SQLName statementName;
   private final List<SQLExpr> parameters = new ArrayList();

   public SQLName getStatementName() {
      return this.statementName;
   }

   public void setStatementName(SQLName statementName) {
      this.statementName = statementName;
   }

   public List<SQLExpr> getParameters() {
      return this.parameters;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.statementName);
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.statementName != null) {
         children.add(this.statementName);
      }

      children.addAll(this.parameters);
      return children;
   }
}
