package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLGrantStatement;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbGrantStatement extends SQLGrantStatement implements MariadbStatement {
   private SQLExpr identifiedByUser;
   private List<SQLExpr> identifiedByRoles = new ArrayList();
   private boolean as;
   private boolean withRole;
   private String type;
   private boolean except;
   private boolean require;
   private boolean none;
   private boolean with;
   private List<SQLExpr> tlsOptions = new ArrayList();
   private List<SQLExpr> resourceOptions = new ArrayList();

   public MariadbGrantStatement(DbType dbType) {
      super(dbType);
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.privileges);
         this.acceptChild(visitor, this.resource);
         this.acceptChild(visitor, this.users);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((MariadbASTVisitor)visitor);
   }

   public boolean isAs() {
      return this.as;
   }

   public void setAs(boolean as) {
      this.as = as;
   }

   public SQLExpr getIdentifiedByUser() {
      return this.identifiedByUser;
   }

   public void setIdentifiedByUser(SQLExpr identifiedByUser) {
      this.identifiedByUser = identifiedByUser;
   }

   public List<SQLExpr> getIdentifiedByRoles() {
      return this.identifiedByRoles;
   }

   public void setIdentifiedByRoles(List<SQLExpr> identifiedByRoles) {
      this.identifiedByRoles = identifiedByRoles;
   }

   public boolean isWithRole() {
      return this.withRole;
   }

   public void setWithRole(boolean withRole) {
      this.withRole = withRole;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public boolean isExcept() {
      return this.except;
   }

   public void setExcept(boolean except) {
      this.except = except;
   }

   public boolean isRequire() {
      return this.require;
   }

   public void setRequire(boolean require) {
      this.require = require;
   }

   public List<SQLExpr> getTlsOptions() {
      return this.tlsOptions;
   }

   public void setTlsOptions(List<SQLExpr> tlsOptions) {
      this.tlsOptions = tlsOptions;
   }

   public List<SQLExpr> getResourceOptions() {
      return this.resourceOptions;
   }

   public void setResourceOptions(List<SQLExpr> resourceOptions) {
      this.resourceOptions = resourceOptions;
   }

   public boolean isNone() {
      return this.none;
   }

   public void setNone(boolean none) {
      this.none = none;
   }

   public boolean isWith() {
      return this.with;
   }

   public void setWith(boolean with) {
      this.with = with;
   }
}
