package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbRaftLeaderTransferStatement extends MariadbStatementImpl {
   private SQLCharExpr shard;
   private SQLCharExpr from;
   private SQLCharExpr to;
   private SQLIntegerExpr timeout;

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.shard);
         this.acceptChild(visitor, this.from);
         this.acceptChild(visitor, this.to);
         this.acceptChild(visitor, this.timeout);
      }

      visitor.endVisit(this);
   }

   public SQLCharExpr getShard() {
      return this.shard;
   }

   public void setShard(SQLCharExpr shard) {
      this.shard = shard;
   }

   public SQLCharExpr getFrom() {
      return this.from;
   }

   public void setFrom(SQLCharExpr from) {
      this.from = from;
   }

   public SQLCharExpr getTo() {
      return this.to;
   }

   public void setTo(SQLCharExpr to) {
      this.to = to;
   }

   public SQLIntegerExpr getTimeout() {
      return this.timeout;
   }

   public void setTimeout(SQLIntegerExpr timeout) {
      this.timeout = timeout;
   }
}
