package com.chenyang.druid.sql.dialect.mysql.ast;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLPrimaryKey;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;

public class MySqlPrimaryKey extends MySqlKey implements SQLPrimaryKey {
   public MySqlPrimaryKey() {
      this.dbType = DbType.mysql;
   }

   protected void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getColumns());
      }

      visitor.endVisit(this);
   }

   public MySqlPrimaryKey clone() {
      MySqlPrimaryKey x = new MySqlPrimaryKey();
      this.cloneTo(x);
      return x;
   }
}
