package com.chenyang.druid.sql.dialect.mysql.ast;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;

public class MySqlUnique extends MySqlKey {
   protected void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getColumns());
      }

      visitor.endVisit(this);
   }

   public MySqlUnique clone() {
      MySqlUnique x = new MySqlUnique();
      this.cloneTo(x);
      return x;
   }

   public SQLExpr getDbPartitionBy() {
      return this.indexDefinition.getDbPartitionBy();
   }

   public void setDbPartitionBy(SQLExpr x) {
      this.indexDefinition.setDbPartitionBy(x);
   }

   public boolean isGlobal() {
      return this.indexDefinition.isGlobal();
   }

   public void setGlobal(boolean global) {
      this.indexDefinition.setGlobal(global);
   }

   public boolean isLocal() {
      return this.indexDefinition.isLocal();
   }

   public void setLocal(boolean local) {
      this.indexDefinition.setLocal(local);
   }

   public SQLExpr getTablePartitions() {
      return this.indexDefinition.getTbPartitions();
   }

   public void setTablePartitions(SQLExpr x) {
      this.indexDefinition.setTbPartitions(x);
   }

   public SQLExpr getTablePartitionBy() {
      return this.indexDefinition.getTbPartitionBy();
   }

   public void setTablePartitionBy(SQLExpr x) {
      this.indexDefinition.setTbPartitionBy(x);
   }
}
