package com.chenyang.druid.sql.dialect.mysql.ast.clause;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLIfStatement;
import com.chenyang.druid.sql.dialect.mysql.ast.MySqlObjectImpl;
import com.chenyang.druid.sql.dialect.mysql.ast.statement.MySqlStatementImpl;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlCaseStatement extends MySqlStatementImpl {
   private SQLExpr condition;
   private List<MySqlWhenStatement> whenList = new ArrayList();
   private SQLIfStatement.Else elseItem;

   public SQLExpr getCondition() {
      return this.condition;
   }

   public void setCondition(SQLExpr condition) {
      this.condition = condition;
   }

   public List<MySqlWhenStatement> getWhenList() {
      return this.whenList;
   }

   public void setWhenList(List<MySqlWhenStatement> whenList) {
      this.whenList = whenList;
   }

   public void addWhenStatement(MySqlWhenStatement stmt) {
      this.whenList.add(stmt);
   }

   public SQLIfStatement.Else getElseItem() {
      return this.elseItem;
   }

   public void setElseItem(SQLIfStatement.Else elseItem) {
      this.elseItem = elseItem;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.condition);
         this.acceptChild(visitor, this.whenList);
         this.acceptChild(visitor, this.elseItem);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.addAll(children);
      children.addAll(this.whenList);
      children.addAll(this.whenList);
      if (this.elseItem != null) {
         children.add(this.elseItem);
      }

      return children;
   }

   public static class MySqlWhenStatement extends MySqlObjectImpl {
      private SQLExpr condition;
      private List<SQLStatement> statements = new ArrayList();

      public void accept0(MySqlASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.condition);
            this.acceptChild(visitor, this.statements);
         }

         visitor.endVisit(this);
      }

      public SQLExpr getCondition() {
         return this.condition;
      }

      public void setCondition(SQLExpr condition) {
         this.condition = condition;
      }

      public List<SQLStatement> getStatements() {
         return this.statements;
      }

      public void setStatements(List<SQLStatement> statements) {
         this.statements = statements;
      }
   }
}
