package com.chenyang.druid.sql.dialect.mysql.ast.clause;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.dialect.mysql.ast.statement.MySqlStatementImpl;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;

public class MySqlCursorDeclareStatement extends MySqlStatementImpl {
   private SQLName cursorName;
   private SQLSelect select;

   public SQLName getCursorName() {
      return this.cursorName;
   }

   public void setCursorName(SQLName cursorName) {
      if (cursorName != null) {
         cursorName.setParent(this);
      }

      this.cursorName = cursorName;
   }

   public void setCursorName(String cursorName) {
      this.setCursorName((SQLName)(new SQLIdentifierExpr(cursorName)));
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect select) {
      if (select != null) {
         select.setParent(this);
      }

      this.select = select;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.select);
      }

      visitor.endVisit(this);
   }
}
