package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlChecksumTableStatement extends MySqlStatementImpl {
   private final List<SQLExprTableSource> tables = new ArrayList();
   private SQLExpr identified;
   private boolean quick;
   private boolean extended;

   public void addTable(SQLExprTableSource table) {
      if (table != null) {
         table.setParent(this);
         this.tables.add(table);
      }
   }

   public List<SQLExprTableSource> getTables() {
      return this.tables;
   }

   public boolean isQuick() {
      return this.quick;
   }

   public void setQuick(boolean quick) {
      this.quick = quick;
   }

   public boolean isExtended() {
      return this.extended;
   }

   public void setExtended(boolean extended) {
      this.extended = extended;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tables);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getIdentified() {
      return this.identified;
   }

   public void setIdentified(SQLExpr identified) {
      this.identified = identified;
   }
}
