package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLOrderBy;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlDeleteStatement extends SQLDeleteStatement {
   private boolean lowPriority = false;
   private boolean quick = false;
   private boolean ignore = false;
   private SQLOrderBy orderBy;
   private SQLLimit limit;
   private boolean forceAllPartitions = false;
   private SQLName forcePartition;
   private List<SQLCommentHint> hints;
   private boolean fulltextDictionary = false;

   public MySqlDeleteStatement() {
      super(DbType.mysql);
   }

   public MySqlDeleteStatement clone() {
      MySqlDeleteStatement x = new MySqlDeleteStatement();
      this.cloneTo(x);
      x.lowPriority = this.lowPriority;
      x.quick = this.quick;
      x.ignore = this.ignore;
      x.fulltextDictionary = this.fulltextDictionary;
      if (this.using != null) {
         x.setUsing(this.using.clone());
      }

      if (this.orderBy != null) {
         x.setOrderBy(this.orderBy.clone());
      }

      if (this.limit != null) {
         x.setLimit(this.limit.clone());
      }

      return x;
   }

   public List<SQLCommentHint> getHints() {
      if (this.hints == null) {
         this.hints = new ArrayList();
      }

      return this.hints;
   }

   public int getHintsSize() {
      return this.hints == null ? 0 : this.hints.size();
   }

   public boolean isLowPriority() {
      return this.lowPriority;
   }

   public void setLowPriority(boolean lowPriority) {
      this.lowPriority = lowPriority;
   }

   public boolean isQuick() {
      return this.quick;
   }

   public void setQuick(boolean quick) {
      this.quick = quick;
   }

   public boolean isIgnore() {
      return this.ignore;
   }

   public void setIgnore(boolean ignore) {
      this.ignore = ignore;
   }

   public SQLOrderBy getOrderBy() {
      return this.orderBy;
   }

   public void setOrderBy(SQLOrderBy orderBy) {
      this.orderBy = orderBy;
   }

   public SQLLimit getLimit() {
      return this.limit;
   }

   public void setLimit(SQLLimit limit) {
      if (limit != null) {
         limit.setParent(this);
      }

      this.limit = limit;
   }

   public boolean isFulltextDictionary() {
      return this.fulltextDictionary;
   }

   public void setFulltextDictionary(boolean fulltextDictionary) {
      this.fulltextDictionary = fulltextDictionary;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   protected void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.with != null) {
            this.with.accept(visitor);
         }

         if (this.tableSource != null) {
            this.tableSource.accept(visitor);
         }

         if (this.where != null) {
            this.where.accept(visitor);
         }

         if (this.from != null) {
            this.from.accept(visitor);
         }

         if (this.using != null) {
            this.using.accept(visitor);
         }

         if (this.orderBy != null) {
            this.orderBy.accept(visitor);
         }

         if (this.limit != null) {
            this.limit.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public boolean isForceAllPartitions() {
      return this.forceAllPartitions;
   }

   public void setForceAllPartitions(boolean forceAllPartitions) {
      this.forceAllPartitions = forceAllPartitions;
   }

   public SQLName getForcePartition() {
      return this.forcePartition;
   }

   public void setForcePartition(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.forcePartition = x;
   }
}
