package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MySqlKillStatement extends SQLStatementImpl {
   private Type type;
   private List<SQLExpr> threadIds = new ArrayList();

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public SQLExpr getThreadId() {
      return (SQLExpr)this.threadIds.get(0);
   }

   public void setThreadId(SQLExpr threadId) {
      if (this.threadIds.size() == 0) {
         this.threadIds.add(threadId);
      } else {
         this.threadIds.set(0, threadId);
      }
   }

   public List<SQLExpr> getThreadIds() {
      return this.threadIds;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.threadIds);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public static enum Type {
      CONNECTION,
      QUERY;
   }
}
