package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlManageInstanceGroupStatement extends MySqlStatementImpl {
   private List<SQLExpr> groupNames = new ArrayList();
   private SQLIntegerExpr replication;
   private SQLName operation;

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.groupNames);
         this.acceptChild(visitor, this.replication);
         this.acceptChild(visitor, this.operation);
      }

      visitor.endVisit(this);
   }

   public List<String> getGroupNamesToString() {
      List<String> names = new ArrayList(this.groupNames.size());

      for(SQLExpr groupName : this.groupNames) {
         names.add(groupName.toString());
      }

      return names;
   }

   public List<SQLExpr> getGroupNames() {
      return this.groupNames;
   }

   public SQLIntegerExpr getReplication() {
      return this.replication;
   }

   public void setReplication(SQLIntegerExpr replication) {
      this.replication = replication;
   }

   public SQLName getOperation() {
      return this.operation;
   }

   public void setOperation(SQLName operation) {
      this.operation = operation;
   }
}
