package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.dialect.mysql.ast.MySqlObjectImpl;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlRenameTableStatement extends MySqlStatementImpl implements SQLAlterStatement {
   private List<Item> items = new ArrayList(2);

   public List<Item> getItems() {
      return this.items;
   }

   public void addItem(Item item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
      }

      visitor.endVisit(this);
   }

   public static class Item extends MySqlObjectImpl {
      private SQLName name;
      private SQLName to;

      public SQLName getName() {
         return this.name;
      }

      public void setName(SQLName name) {
         this.name = name;
      }

      public SQLName getTo() {
         return this.to;
      }

      public void setTo(SQLName to) {
         this.to = to;
      }

      public void accept0(MySqlASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.name);
            this.acceptChild(visitor, this.to);
         }

         visitor.endVisit(this);
      }
   }
}
