package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlShowProfileStatement extends MySqlStatementImpl implements MySqlShowStatement {
   private List<Type> types = new ArrayList();
   private SQLExpr forQuery;
   private SQLLimit limit;

   public void accept0(MySqlASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public List<Type> getTypes() {
      return this.types;
   }

   public SQLExpr getForQuery() {
      return this.forQuery;
   }

   public void setForQuery(SQLExpr forQuery) {
      this.forQuery = forQuery;
   }

   public SQLLimit getLimit() {
      return this.limit;
   }

   public void setLimit(SQLLimit limit) {
      this.limit = limit;
   }

   public static enum Type {
      ALL("ALL"),
      BLOCK_IO("BLOCK IO"),
      CONTEXT_SWITCHES("CONTEXT SWITCHES"),
      CPU("CPU"),
      IPC("IPC"),
      MEMORY("MEMORY"),
      PAGE_FAULTS("PAGE FAULTS"),
      SOURCE("SOURCE"),
      SWAPS("SWAPS");

      public final String name;

      private Type(String name) {
         this.name = name;
      }
   }
}
