package com.chenyang.druid.sql.dialect.mysql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public abstract class MySqlStatementImpl extends SQLStatementImpl implements MySqlStatement {
   public MySqlStatementImpl() {
      super(DbType.mysql);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MySqlASTVisitor v) {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public List<SQLObject> getChildren() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }
}
