package com.chenyang.druid.sql.dialect.oracle.ast.clause;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class CycleClause extends OracleSQLObjectImpl {
   private final List<SQLExpr> aliases = new ArrayList();
   private SQLExpr mark;
   private SQLExpr value;
   private SQLExpr defaultValue;

   public SQLExpr getMark() {
      return this.mark;
   }

   public void setMark(SQLExpr mark) {
      if (mark != null) {
         mark.setParent(this);
      }

      this.mark = mark;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.value = value;
   }

   public SQLExpr getDefaultValue() {
      return this.defaultValue;
   }

   public void setDefaultValue(SQLExpr defaultValue) {
      if (defaultValue != null) {
         defaultValue.setParent(this);
      }

      this.defaultValue = defaultValue;
   }

   public List<SQLExpr> getAliases() {
      return this.aliases;
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.aliases);
         this.acceptChild(visitor, this.mark);
         this.acceptChild(visitor, this.value);
         this.acceptChild(visitor, this.defaultValue);
      }

      visitor.endVisit(this);
   }

   public CycleClause clone() {
      CycleClause x = new CycleClause();

      for(SQLExpr alias : this.aliases) {
         SQLExpr alias2 = alias.clone();
         alias2.setParent(x);
         x.aliases.add(alias2);
      }

      if (this.mark != null) {
         this.setMark(this.mark.clone());
      }

      if (this.value != null) {
         this.setValue(this.value.clone());
      }

      if (this.defaultValue != null) {
         this.setDefaultValue(this.defaultValue.clone());
      }

      return x;
   }
}
