package com.chenyang.druid.sql.dialect.oracle.ast.clause;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SampleClause extends OracleSQLObjectImpl implements SQLReplaceable {
   private boolean block = false;
   private final List<SQLExpr> percent = new ArrayList();
   private SQLExpr seedValue;

   public boolean isBlock() {
      return this.block;
   }

   public void setBlock(boolean block) {
      this.block = block;
   }

   public List<SQLExpr> getPercent() {
      return this.percent;
   }

   public void addPercent(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
         this.percent.add(x);
      }
   }

   public SQLExpr getSeedValue() {
      return this.seedValue;
   }

   public void setSeedValue(SQLExpr seedValue) {
      if (seedValue != null) {
         seedValue.setParent(this);
      }

      this.seedValue = seedValue;
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.seedValue);
         this.acceptChild(visitor, this.percent);
      }

      visitor.endVisit(this);
   }

   public SampleClause clone() {
      SampleClause x = new SampleClause();
      x.block = this.block;

      for(SQLExpr item : this.percent) {
         SQLExpr item1 = item.clone();
         item1.setParent(x);
         x.percent.add(item1);
      }

      if (this.seedValue != null) {
         x.setSeedValue(this.seedValue.clone());
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = this.percent.size() - 1; i >= 0; --i) {
         if (this.percent.get(i) == expr) {
            this.percent.set(i, target);
            return true;
         }
      }

      if (expr == this.seedValue) {
         this.setSeedValue(target);
         return true;
      } else {
         return false;
      }
   }
}
