package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLOver;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleAnalytic extends SQLOver implements SQLReplaceable, OracleExpr {
   private OracleAnalyticWindowing windowing;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)visitor);
      }

   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partitionBy);
         this.acceptChild(visitor, this.orderBy);
         this.acceptChild(visitor, this.windowing);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.addAll(this.partitionBy);
      if (this.orderBy != null) {
         children.add(this.orderBy);
      }

      if (this.windowing != null) {
         children.add(this.windowing);
      }

      return children;
   }

   public OracleAnalyticWindowing getWindowing() {
      return this.windowing;
   }

   public OracleAnalytic clone() {
      OracleAnalytic x = new OracleAnalytic();
      this.cloneTo(x);
      if (this.windowing != null) {
         x.setWindowing(this.windowing.clone());
      }

      return x;
   }

   public void setWindowing(OracleAnalyticWindowing x) {
      if (x != null) {
         x.setParent(this);
      }

      this.windowing = x;
   }

   public SQLDataType computeDataType() {
      return null;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.partitionBy.size(); ++i) {
         if (this.partitionBy.get(i) == expr) {
            this.partitionBy.set(i, target);
            return true;
         }
      }

      return false;
   }
}
