package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class OracleBinaryDoubleExpr extends SQLNumericLiteralExpr implements OracleExpr {
   private Double value;

   public OracleBinaryDoubleExpr() {
   }

   public OracleBinaryDoubleExpr(Double value) {
      this.value = value;
   }

   public Number getNumber() {
      return this.value;
   }

   public Double getValue() {
      return this.value;
   }

   public void setValue(Double value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         OracleBinaryDoubleExpr other = (OracleBinaryDoubleExpr)obj;
         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue((Double)null);
      } else {
         this.setValue(number.doubleValue());
      }
   }

   public OracleBinaryDoubleExpr clone() {
      return new OracleBinaryDoubleExpr(this.value);
   }
}
