package com.chenyang.druid.sql.dialect.oracle.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class OracleMethodInvokeAccessExpr extends SQLExprImpl {
   private SQLExpr method;
   private SQLExpr call;

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof OracleASTVisitor) {
         OracleASTVisitor visitor = (OracleASTVisitor)v;
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.method);
            this.acceptChild(visitor, this.call);
         }

         visitor.endVisit(this);
      }

   }

   public SQLExpr getMethod() {
      return this.method;
   }

   public void setMethod(SQLExpr method) {
      this.method = method;
   }

   public SQLExpr getCall() {
      return this.call;
   }

   public void setCall(SQLExpr call) {
      this.call = call;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         OracleMethodInvokeAccessExpr other = (OracleMethodInvokeAccessExpr)obj;
         if (this.method == null) {
            if (other.method != null) {
               return false;
            }
         } else if (!this.method.equals(other.method)) {
            return false;
         }

         if (this.call == null) {
            if (other.call != null) {
               return false;
            }
         } else if (!this.call.equals(other.call)) {
            return false;
         }

         return true;
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.method == null ? 0 : this.method.hashCode()) + (this.call == null ? 0 : this.call.hashCode());
      return result;
   }

   public SQLExpr clone() {
      OracleMethodInvokeAccessExpr expr = new OracleMethodInvokeAccessExpr();
      expr.setMethod(this.method);
      expr.setCall(this.call);
      return expr;
   }
}
