package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleAlterTableSplitPartition extends OracleAlterTableItem {
   private SQLName name;
   private List<SQLExpr> at = new ArrayList();
   private List<SQLExpr> values = new ArrayList();
   private List<NestedTablePartitionSpec> into = new ArrayList();
   private UpdateIndexesClause updateIndexes = null;

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.at);
         this.acceptChild(visitor, this.values);
         this.acceptChild(visitor, this.updateIndexes);
      }

      visitor.endVisit(this);
   }

   public UpdateIndexesClause getUpdateIndexes() {
      return this.updateIndexes;
   }

   public void setUpdateIndexes(UpdateIndexesClause updateIndexes) {
      this.updateIndexes = updateIndexes;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public List<SQLExpr> getAt() {
      return this.at;
   }

   public void setAt(List<SQLExpr> at) {
      this.at = at;
   }

   public List<NestedTablePartitionSpec> getInto() {
      return this.into;
   }

   public void setInto(List<NestedTablePartitionSpec> into) {
      this.into = into;
   }

   public List<SQLExpr> getValues() {
      return this.values;
   }

   public void setValues(List<SQLExpr> values) {
      this.values = values;
   }

   public static class NestedTablePartitionSpec extends OracleSQLObjectImpl {
      private SQLName partition;
      private List<SQLObject> segmentAttributeItems = new ArrayList();

      public void accept0(OracleASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.partition);
            this.acceptChild(visitor, this.segmentAttributeItems);
         }

         visitor.endVisit(this);
      }

      public SQLName getPartition() {
         return this.partition;
      }

      public void setPartition(SQLName partition) {
         this.partition = partition;
      }

      public List<SQLObject> getSegmentAttributeItems() {
         return this.segmentAttributeItems;
      }

      public void setSegmentAttributeItems(List<SQLObject> segmentAttributeItems) {
         this.segmentAttributeItems = segmentAttributeItems;
      }
   }

   public static class TableSpaceItem extends OracleSQLObjectImpl {
      private SQLName tablespace;

      public TableSpaceItem() {
      }

      public TableSpaceItem(SQLName tablespace) {
         this.tablespace = tablespace;
      }

      public void accept0(OracleASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tablespace);
         }

         visitor.endVisit(this);
      }

      public SQLName getTablespace() {
         return this.tablespace;
      }

      public void setTablespace(SQLName tablespace) {
         this.tablespace = tablespace;
      }
   }

   public static class UpdateIndexesClause extends OracleSQLObjectImpl {
      private List<SQLObject> items = new ArrayList();

      public void accept0(OracleASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.items);
         }

         visitor.endVisit(this);
      }

      public List<SQLObject> getItems() {
         return this.items;
      }

      public void setItems(List<SQLObject> items) {
         this.items = items;
      }
   }
}
