package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleCreatePackageStatement extends OracleStatementImpl implements SQLCreateStatement {
   private boolean orReplace;
   private SQLName name;
   private boolean body;
   private final List<SQLStatement> statements = new ArrayList();

   public OracleCreatePackageStatement() {
      super.setDbType(DbType.oracle);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.statements);
      }

      visitor.endVisit(this);
   }

   public OracleCreatePackageStatement clone() {
      OracleCreatePackageStatement x = new OracleCreatePackageStatement();
      x.orReplace = this.orReplace;
      if (this.name != null) {
         x.setName(this.name.clone());
      }

      x.body = this.body;

      for(SQLStatement stmt : this.statements) {
         SQLStatement s2 = stmt.clone();
         s2.setParent(x);
         x.statements.add(s2);
      }

      return x;
   }

   public boolean isOrReplace() {
      return this.orReplace;
   }

   public void setOrReplace(boolean orReplace) {
      this.orReplace = orReplace;
   }

   public boolean isBody() {
      return this.body;
   }

   public void setBody(boolean body) {
      this.body = body;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public List<SQLStatement> getStatements() {
      return this.statements;
   }
}
