package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class OracleRunStatement extends SQLStatementImpl implements OracleStatement {
   private SQLExpr expr;

   public OracleRunStatement() {
      super(DbType.oracle);
   }

   public OracleRunStatement(SQLExpr expr) {
      super(DbType.oracle);
      this.setExpr(expr);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }
}
