package com.chenyang.druid.sql.dialect.oracle.ast.stmt;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLTableSource;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class OracleSelectJoin extends SQLJoinTableSource implements OracleSelectTableSource {
   protected OracleSelectPivotBase pivot;

   public OracleSelectJoin(String alias) {
      super(alias);
   }

   public OracleSelectJoin() {
   }

   public OracleSelectJoin(SQLTableSource left, JoinType joinType, SQLTableSource right, SQLExpr condition) {
      super(left, joinType, right, condition);
   }

   public OracleSelectPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(OracleSelectPivotBase pivot) {
      this.pivot = pivot;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   protected void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.left);
         this.acceptChild(visitor, this.right);
         this.acceptChild(visitor, this.condition);
         this.acceptChild(visitor, this.using);
         this.acceptChild(visitor, this.flashback);
      }

      visitor.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            OracleSelectJoin that = (OracleSelectJoin)o;
            if (this.pivot != null) {
               if (!this.pivot.equals(that.pivot)) {
                  return false;
               }
            } else if (that.pivot != null) {
               return false;
            }

            return this.flashback != null ? this.flashback.equals(that.flashback) : that.flashback == null;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.pivot != null ? this.pivot.hashCode() : 0;
      result = 31 * result + (this.flashback != null ? this.flashback.hashCode() : 0);
      return result;
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }

   public SQLJoinTableSource clone() {
      OracleSelectJoin x = new OracleSelectJoin();
      this.cloneTo(x);
      if (this.pivot != null) {
         x.setPivot(this.pivot.clone());
      }

      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      return x;
   }

   public void setLeft(String tableName) {
      SQLExprTableSource tableSource;
      if (tableName != null && tableName.length() != 0) {
         tableSource = new OracleSelectTableReference(new SQLIdentifierExpr(tableName));
      } else {
         tableSource = null;
      }

      this.setLeft(tableSource);
   }

   public void setRight(String tableName) {
      SQLExprTableSource tableSource;
      if (tableName != null && tableName.length() != 0) {
         tableSource = new OracleSelectTableReference(new SQLIdentifierExpr(tableName));
      } else {
         tableSource = null;
      }

      this.setRight(tableSource);
   }

   public SQLJoinTableSource join(SQLTableSource right, JoinType joinType, SQLExpr condition) {
      SQLJoinTableSource joined = new OracleSelectJoin(this, joinType, right, condition);
      return joined;
   }
}
