package com.chenyang.druid.sql.dialect.oracle.parser;

import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.ast.SQLParameter;
import com.chenyang.druid.sql.ast.SQLStatement;
import java.util.ArrayList;
import java.util.List;

public class OracleFunctionDataType extends SQLDataTypeImpl {
   private boolean isStatic = false;
   private final List<SQLParameter> parameters = new ArrayList();
   private SQLDataType returnDataType;
   private SQLStatement block;

   public boolean isStatic() {
      return this.isStatic;
   }

   public void setStatic(boolean aStatic) {
      this.isStatic = aStatic;
   }

   public List<SQLParameter> getParameters() {
      return this.parameters;
   }

   public SQLDataType getReturnDataType() {
      return this.returnDataType;
   }

   public void setReturnDataType(SQLDataType x) {
      if (x != null) {
         x.setParent(this);
      }

      this.returnDataType = x;
   }

   public OracleFunctionDataType clone() {
      OracleFunctionDataType x = new OracleFunctionDataType();
      this.cloneTo(x);
      x.isStatic = this.isStatic;
      if (this.returnDataType != null) {
         x.setReturnDataType(this.returnDataType.clone());
      }

      for(SQLParameter parameter : this.parameters) {
         SQLParameter p2 = parameter.clone();
         p2.setParent(x);
         x.parameters.add(p2);
      }

      return x;
   }

   public SQLStatement getBlock() {
      return this.block;
   }

   public void setBlock(SQLStatement block) {
      if (block != null) {
         block.setParent(this);
      }

      this.block = block;
   }
}
