package com.chenyang.druid.sql.dialect.phoenix.parser;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLInsertInto;
import com.chenyang.druid.sql.parser.Lexer;
import com.chenyang.druid.sql.parser.SQLExprParser;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.SQLStatementParser;
import com.chenyang.druid.sql.parser.Token;

public class PhoenixStatementParser extends SQLStatementParser {
   public PhoenixStatementParser(String sql) {
      super((SQLExprParser)(new PhoenixExprParser(sql, new SQLParserFeature[0])));
   }

   public PhoenixStatementParser(Lexer lexer) {
      super((SQLExprParser)(new PhoenixExprParser(lexer)));
   }

   protected void parseInsertColumns(SQLInsertInto insert) {
      if (this.lexer.token() != Token.RPAREN) {
         while(true) {
            SQLName expr = this.exprParser.name();
            expr.setParent(insert);
            insert.getColumns().add(expr);
            if (this.lexer.token() == Token.IDENTIFIER) {
               String text = this.lexer.stringVal();
               if (!text.equalsIgnoreCase("TINYINT") && !text.equalsIgnoreCase("BIGINT") && !text.equalsIgnoreCase("INTEGER") && !text.equalsIgnoreCase("DOUBLE") && !text.equalsIgnoreCase("DATE") && !text.equalsIgnoreCase("VARCHAR")) {
                  if (text.equalsIgnoreCase("CHAR")) {
                     this.lexer.nextToken();
                     this.accept(Token.LPAREN);
                     SQLExpr char_len = this.exprParser.primary();
                     this.accept(Token.RPAREN);
                     String dataType = text + "(" + char_len.toString() + ")";
                     expr.getAttributes().put("dataType", dataType);
                  }
               } else {
                  expr.getAttributes().put("dataType", text);
                  this.lexer.nextToken();
               }
            }

            if (this.lexer.token() != Token.COMMA) {
               return;
            }

            this.lexer.nextToken();
         }
      }
   }
}
