package com.chenyang.druid.sql.dialect.postgresql.ast.expr;

import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.dialect.postgresql.ast.PGSQLObjectImpl;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PGSQLObjectCollection extends PGSQLObjectImpl implements List<SQLObject> {
   protected List<SQLObject> datas = new ArrayList();

   public int size() {
      return this.datas.size();
   }

   public boolean isEmpty() {
      return this.datas.isEmpty();
   }

   public boolean contains(Object o) {
      return this.datas.contains(o);
   }

   public Iterator<SQLObject> iterator() {
      return this.datas.iterator();
   }

   public Object[] toArray() {
      return this.datas.toArray(new Object[0]);
   }

   public <T> T[] toArray(T[] a) {
      return (T[])this.datas.toArray(new Object[0]);
   }

   public boolean add(SQLObject o) {
      this.datas.add(o);
      o.setParent(this);
      return true;
   }

   public boolean remove(Object o) {
      this.datas.remove(o);
      return true;
   }

   public boolean containsAll(Collection<?> c) {
      return this.datas.containsAll(c);
   }

   public boolean addAll(Collection<? extends SQLObject> c) {
      return this.datas.addAll(c);
   }

   public boolean addAll(int index, Collection<? extends SQLObject> c) {
      return this.datas.addAll(index, c);
   }

   public boolean removeAll(Collection<?> c) {
      return this.datas.removeAll(c);
   }

   public boolean retainAll(Collection<?> c) {
      return this.datas.retainAll(c);
   }

   public void clear() {
      this.datas.clear();
   }

   public SQLObject get(int index) {
      return (SQLObject)this.datas.get(index);
   }

   public SQLObject set(int index, SQLObject element) {
      return (SQLObject)this.datas.set(index, element);
   }

   public void add(int index, SQLObject element) {
      this.datas.add(index, element);
   }

   public SQLObject remove(int index) {
      return (SQLObject)this.datas.remove(index);
   }

   public int indexOf(Object o) {
      return this.datas.indexOf(o);
   }

   public int lastIndexOf(Object o) {
      return this.datas.lastIndexOf(o);
   }

   public ListIterator<SQLObject> listIterator() {
      return this.datas.listIterator();
   }

   public ListIterator<SQLObject> listIterator(int index) {
      return this.datas.listIterator(index);
   }

   public List<SQLObject> subList(int fromIndex, int toIndex) {
      return this.datas.subList(fromIndex, toIndex);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.datas);
      }

      visitor.endVisit(this);
   }
}
