package com.chenyang.druid.sql.dialect.postgresql.ast.expr.tablesource;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.dialect.postgresql.ast.PGSQLObject;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class PGSubqueryTableSource extends SQLSubqueryTableSource implements PGSQLObject, PGTableSource {
   protected boolean only;

   public PGSubqueryTableSource clone() {
      PGSubqueryTableSource x = new PGSubqueryTableSource();
      this.cloneTo(x);
      x.only = this.only;
      return x;
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this) && this.select != null) {
         this.select.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }
}
