package com.chenyang.druid.sql.dialect.postgresql.ast.stmt;

import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class PGAlterSchemaStatement extends SQLStatementImpl implements PGSQLStatement, SQLAlterStatement {
   private SQLIdentifierExpr schemaName;
   private SQLIdentifierExpr newName;
   private SQLIdentifierExpr newOwner;

   public SQLIdentifierExpr getSchemaName() {
      return this.schemaName;
   }

   public void setSchemaName(SQLIdentifierExpr schemaName) {
      this.schemaName = schemaName;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public SQLIdentifierExpr getNewName() {
      return this.newName;
   }

   public void setNewName(SQLIdentifierExpr newName) {
      this.newName = newName;
   }

   public SQLIdentifierExpr getNewOwner() {
      return this.newOwner;
   }

   public void setNewOwner(SQLIdentifierExpr newOwner) {
      this.newOwner = newOwner;
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schemaName);
         this.acceptChild(visitor, this.newName);
         this.acceptChild(visitor, this.newOwner);
      }

      visitor.endVisit(this);
   }
}
