package com.chenyang.druid.sql.dialect.postgresql.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableStatement;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class PGAlterTableStatement extends SQLAlterTableStatement implements PGSQLStatement, SQLAlterStatement {
   private boolean only = false;
   private boolean allInTableSpace = false;

   public boolean isAllInTableSpace() {
      return this.allInTableSpace;
   }

   public void setAllInTableSpace(boolean allInTableSpace) {
      this.allInTableSpace = allInTableSpace;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public PGAlterTableStatement() {
      this.dbType = DbType.postgresql;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getTableSource());
         this.acceptChild(visitor, this.getItems());
      }

      visitor.endVisit(this);
   }
}
