package com.chenyang.druid.sql.dialect.spark.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.dialect.spark.ast.SparkSqlExprImpl;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import java.util.ArrayList;
import java.util.List;

public class SparkColumnSpecExpr extends SparkSqlExprImpl {
   private SQLExpr name;
   private SQLExpr type;
   private SQLExpr comment;
   private SQLExpr position;

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      this.name = name;
   }

   public SQLExpr getType() {
      return this.type;
   }

   public void setType(SQLExpr type) {
      this.type = type;
   }

   public SQLExpr getComment() {
      return this.comment;
   }

   public void setComment(SQLExpr comment) {
      this.comment = comment;
   }

   public SQLExpr getPosition() {
      return this.position;
   }

   public void setPosition(SQLExpr position) {
      this.position = position;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      if (this.type != null) {
         children.add(this.type);
      }

      if (this.comment != null) {
         children.add(this.comment);
      }

      if (this.position != null) {
         children.add(this.position);
      }

      return children;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.name);
         this.acceptChild(v, this.type);
         this.acceptChild(v, this.comment);
         this.acceptChild(v, this.position);
      }

      v.endVisit(this);
   }

   public SparkColumnSpecExpr clone() {
      SparkColumnSpecExpr e = new SparkColumnSpecExpr();
      if (this.name != null) {
         e.name = this.name.clone();
      }

      if (this.type != null) {
         e.type = this.type.clone();
      }

      if (this.comment != null) {
         e.comment = this.comment.clone();
      }

      if (this.position != null) {
         e.position = this.position.clone();
      }

      return e;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (!this.objectNullEquals(this, o)) {
         return false;
      } else {
         SparkColumnSpecExpr that = (SparkColumnSpecExpr)o;
         if (!this.objectEquals(that.name, this.name)) {
            return false;
         } else if (!this.objectEquals(that.type, this.type)) {
            return false;
         } else if (!this.objectEquals(that.comment, this.comment)) {
            return false;
         } else {
            return this.objectEquals(that.position, this.position);
         }
      }
   }

   public int hashCode() {
      int hashCode = this.name == null ? 0 : 31 * this.name.hashCode();
      if (this.type != null) {
         hashCode = 31 * hashCode + this.type.hashCode();
      }

      if (this.comment != null) {
         hashCode = 31 * hashCode + this.comment.hashCode();
      }

      if (this.position != null) {
         hashCode = 31 * hashCode + this.position.hashCode();
      }

      return hashCode;
   }
}
