package com.chenyang.druid.sql.dialect.spark.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.dialect.spark.ast.SparkSqlExprImpl;
import com.chenyang.druid.sql.dialect.spark.ast.expr.SparkDefProperty;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SparkAlterViewStatement extends SparkStatementImpl {
   private SQLExpr name;
   private SQLSelect select;
   private SparkAlterViewReNameTo rename;
   private SparkAlterViewSetUnsetProps setProps;

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      this.name = name;
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect select) {
      this.select = select;
   }

   public SparkAlterViewReNameTo getRename() {
      return this.rename;
   }

   public void setRename(SparkAlterViewReNameTo rename) {
      this.rename = rename;
   }

   public SparkAlterViewSetUnsetProps getSetProps() {
      return this.setProps;
   }

   public void setSetProps(SparkAlterViewSetUnsetProps setProps) {
      this.setProps = setProps;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      if (this.select != null) {
         children.add(this.select);
      }

      if (this.rename != null) {
         children.add(this.rename);
      }

      if (this.setProps != null) {
         children.add(this.setProps);
      }

      return children;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.name);
         this.acceptChild(v, this.select);
         this.acceptChild(v, this.rename);
         this.acceptChild(v, this.setProps);
      }

      v.endVisit(this);
   }

   public SparkAlterViewStatement clone() {
      SparkAlterViewStatement view = new SparkAlterViewStatement();
      view.name = this.name.clone();
      view.select = this.select == null ? null : this.select.clone();
      view.rename = this.rename == null ? null : this.rename.clone();
      view.setProps = this.setProps == null ? null : this.setProps.clone();
      return view;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (!this.objectNullEquals(this, o)) {
         return false;
      } else {
         SparkAlterViewStatement that = (SparkAlterViewStatement)o;
         if (!this.objectEquals(this.select, that.select)) {
            return false;
         } else if (!this.objectEquals(this.rename, that.rename)) {
            return false;
         } else {
            return this.objectEquals(this.setProps, that.setProps);
         }
      }
   }

   public int hashCode() {
      int hash = this.name.hashCode();
      hash = 31 * hash + (this.select == null ? 0 : this.select.hashCode());
      hash = 31 * hash + (this.rename == null ? 0 : this.rename.hashCode());
      hash = 31 * hash + (this.setProps == null ? 0 : this.setProps.hashCode());
      return hash;
   }

   public static class SparkAlterViewReNameTo extends SparkSqlExprImpl {
      private SQLExpr name;

      public SQLExpr getName() {
         return this.name;
      }

      public void setName(SQLExpr name) {
         this.name = name;
         name.setParent(this);
      }

      public List<SQLObject> getChildren() {
         return Arrays.asList(this.name);
      }

      public void accept0(SparkVisitor v) {
         if (v.visit(this)) {
            this.acceptChild(v, this.name);
         }

         v.endVisit(this);
      }

      public SparkAlterViewReNameTo clone() {
         SparkAlterViewReNameTo to = new SparkAlterViewReNameTo();
         to.name = this.name.clone();
         return to;
      }

      public boolean equals(Object o) {
         if (this == o) {
            return true;
         } else if (!this.objectNullEquals(this, o)) {
            return false;
         } else {
            SparkAlterViewReNameTo that = (SparkAlterViewReNameTo)o;
            return this.objectEquals(that.name, this.name);
         }
      }

      public int hashCode() {
         int hash = 31 * (this.name == null ? 0 : this.name.hashCode());
         return hash;
      }
   }

   public static class SparkAlterViewSetUnsetProps extends SparkSqlExprImpl {
      private boolean exists = false;
      private boolean unset = false;
      private List<SparkDefProperty> props = new ArrayList();

      public boolean isExists() {
         return this.exists;
      }

      public void setExists(boolean exists) {
         this.exists = exists;
      }

      public boolean isUnset() {
         return this.unset;
      }

      public void setUnset(boolean unset) {
         this.unset = unset;
      }

      public List<SparkDefProperty> getProps() {
         return this.props;
      }

      public void setProps(List<SparkDefProperty> props) {
         for(SparkDefProperty prop : props) {
            prop.setParent(this);
         }

         this.props = props;
      }

      public List<SQLObject> getChildren() {
         List<SQLObject> children = new ArrayList();
         children.addAll(this.props);
         return children;
      }

      public void accept0(SparkVisitor v) {
         if (v.visit(this)) {
            this.acceptChild(v, this.props);
         }

         v.endVisit(this);
      }

      public SparkAlterViewSetUnsetProps clone() {
         SparkAlterViewSetUnsetProps e = new SparkAlterViewSetUnsetProps();

         for(SparkDefProperty prop : this.props) {
            e.props.add(prop.clone());
         }

         return e;
      }

      public boolean equals(Object o) {
         if (!this.objectNullEquals(this, o)) {
            return false;
         } else {
            SparkAlterViewSetUnsetProps that = (SparkAlterViewSetUnsetProps)o;
            if (this.props.size() != that.props.size()) {
               return false;
            } else {
               for(int i = 0; i < this.props.size(); ++i) {
                  if (!this.objectEquals(this.props.get(i), that.props.get(i))) {
                     return false;
                  }
               }

               return true;
            }
         }
      }

      public int hashCode() {
         int hashCode = this.exists ? 31 : 0;
         hashCode = 31 * hashCode + (this.unset ? 1 : 2);
         return 31 * hashCode + Objects.hashCode(new Object[]{this.props});
      }
   }
}
