package com.chenyang.druid.sql.dialect.spark.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLAssignItem;
import com.chenyang.druid.sql.ast.statement.SQLCreateViewStatement;
import com.chenyang.druid.sql.ast.statement.SQLTableElement;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SparkCreateViewStatement extends SQLCreateViewStatement implements SparkStatement {
   private boolean global;
   private boolean temporary;
   protected final List<SQLAssignItem> tblProperties = new ArrayList();

   public SparkCreateViewStatement() {
      super(DbType.spark);
   }

   public boolean isGlobal() {
      return this.global;
   }

   public void setGlobal(boolean global) {
      this.global = global;
   }

   public boolean isTemporary() {
      return this.temporary;
   }

   public void setTemporary(boolean temporary) {
      this.temporary = temporary;
   }

   public List<SQLAssignItem> getTblProperties() {
      return this.tblProperties;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof SparkVisitor) {
         this.accept0((SparkVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(SparkVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.tableSource != null) {
            this.tableSource.accept(visitor);
         }

         for(int i = 0; i < this.columns.size(); ++i) {
            SQLTableElement column = (SQLTableElement)this.columns.get(i);
            if (column != null) {
               column.accept(visitor);
            }
         }

         if (this.getComment() != null) {
            this.getComment().accept(visitor);
         }

         if (this.subQuery != null) {
            this.subQuery.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public void addTblProperty(String name, SQLExpr value) {
      SQLAssignItem assignItem = new SQLAssignItem(new SQLIdentifierExpr(name), value);
      assignItem.setParent(this);
      this.tblProperties.add(assignItem);
   }
}
