package com.chenyang.druid.sql.dialect.spark.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLExplainStatement;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SparkExplainStatement extends SQLExplainStatement implements SparkStatement {
   private boolean codegen;
   private boolean cost;
   private boolean formatted;

   public SparkExplainStatement() {
      super(DbType.spark);
   }

   public SparkExplainStatement(DbType dbType) {
      super(dbType);
   }

   public boolean isCodegen() {
      return this.codegen;
   }

   public void setCodegen(boolean codegen) {
      this.codegen = codegen;
   }

   public boolean isCost() {
      return this.cost;
   }

   public void setCost(boolean cost) {
      this.cost = cost;
   }

   public boolean isFormatted() {
      return this.formatted;
   }

   public void setFormatted(boolean formatted) {
      this.formatted = formatted;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.statement);
      }

      v.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof SparkVisitor) {
         this.accept0((SparkVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }
}
