package com.chenyang.druid.sql.dialect.spark.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public abstract class SparkStatementImpl extends SQLStatementImpl implements SparkStatement {
   public SparkStatementImpl() {
      this.dbType = DbType.spark;
   }

   public boolean objectEquals(Object a, Object b) {
      return !this.objectNullEquals(a, b) ? false : a.equals(b);
   }

   public boolean objectNullEquals(Object a, Object b) {
      if (a == null && b != null) {
         return false;
      } else if (a != null && b == null) {
         return false;
      } else if (a == null && b == null) {
         return true;
      } else {
         return a == null || a.getClass() == b.getClass();
      }
   }

   protected void accept0(SQLASTVisitor v) {
      this.accept0((SparkVisitor)v);
   }
}
