package com.chenyang.druid.sql.dialect.sqlserver.ast.stmt;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.chenyang.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLServerSelectTableReference extends SQLExprTableSource implements SQLServerSelectTableSource, SQLServerObject {
   protected SQLServerPivotBase pivot;
   protected String pivotAlias;

   public SQLServerSelectTableReference() {
   }

   public SQLServerSelectTableReference(SQLExpr expr) {
      this.setExpr(expr);
   }

   public SQLServerPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(SQLServerPivotBase pivot) {
      if (pivot != null) {
         pivot.setParent(this);
      }

      this.pivot = pivot;
   }

   public String getPivotAlias() {
      return this.pivotAlias;
   }

   public void setPivotAlias(String pivotAlias) {
      this.pivotAlias = pivotAlias;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.sampling);
         this.acceptChild(visitor, this.pivot);
      }

      visitor.endVisit(this);
   }

   public String toString() {
      return SQLUtils.toSQLServerString(this);
   }

   public SQLServerSelectTableReference clone() {
      SQLServerSelectTableReference x = new SQLServerSelectTableReference();
      this.cloneTo(x);
      if (this.pivot != null) {
         x.setPivot(this.pivot.clone());
      }

      x.setPivotAlias(this.getPivotAlias());
      return x;
   }
}
