package com.chenyang.druid.sql.dialect.sqlserver.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerStatement;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.chenyang.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLServerUpdateStatement extends SQLUpdateStatement implements SQLServerStatement {
   private SQLServerTop top;
   private SQLServerOutput output;

   public SQLServerUpdateStatement() {
      super(DbType.sqlserver);
   }

   public SQLServerTop getTop() {
      return this.top;
   }

   public void setTop(SQLServerTop top) {
      if (top != null) {
         top.setParent(this);
      }

      this.top = top;
   }

   public SQLServerOutput getOutput() {
      return this.output;
   }

   public void setOutput(SQLServerOutput output) {
      if (output != null) {
         output.setParent(this);
      }

      this.output = output;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.with);
         this.acceptChild(visitor, this.top);
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.items);
         this.acceptChild(visitor, this.output);
         this.acceptChild(visitor, this.from);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }
}
