package com.chenyang.druid.sql.dialect.sqlserver.ast.stmt;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLHint;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.expr.SQLListExpr;
import com.chenyang.druid.sql.ast.statement.SQLValuesTableSource;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.chenyang.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLServerValuesTableSource extends SQLValuesTableSource implements SQLServerSelectTableSource, SQLServerObject {
   protected SQLServerPivotBase pivot;
   protected String pivotAlias;

   public SQLServerPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(SQLServerPivotBase pivot) {
      this.pivot = pivot;
   }

   public String toString() {
      return SQLUtils.toSQLServerString(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, super.getValues());
         this.acceptChild(visitor, super.getColumns());
         this.acceptChild(visitor, this.pivot);
      }

      visitor.endVisit(this);
   }

   public SQLServerValuesTableSource clone() {
      SQLServerValuesTableSource x = new SQLServerValuesTableSource();
      x.setAlias(this.alias);

      for(SQLListExpr e : this.getValues()) {
         SQLListExpr e2 = e.clone();
         e2.setParent(x);
         x.getValues().add(e2);
      }

      for(SQLName e : this.getColumns()) {
         SQLName e2 = e.clone();
         e2.setParent(x);
         x.getColumns().add(e2);
      }

      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      if (this.pivot != null) {
         x.setPivot(this.pivot.clone());
      }

      x.setPivotAlias(this.pivotAlias);
      return x;
   }

   public String getPivotAlias() {
      return this.pivotAlias;
   }

   public void setPivotAlias(String pivotAlias) {
      this.pivotAlias = pivotAlias;
   }
}
