package com.chenyang.druid.sql.parser;

import com.chenyang.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.chenyang.druid.sql.ast.statement.SQLTableConstraint;

public class SQLDDLParser extends SQLStatementParser {
   public SQLDDLParser(String sql) {
      super(sql);
   }

   public SQLDDLParser(SQLExprParser exprParser) {
      super(exprParser);
   }

   protected SQLTableConstraint parseConstraint() {
      if (this.lexer.token == Token.CONSTRAINT) {
         this.lexer.nextToken();
      }

      if (this.lexer.token == Token.IDENTIFIER) {
         this.exprParser.name();
         throw new ParserException("TODO. " + this.lexer.info());
      } else if (this.lexer.token == Token.PRIMARY) {
         this.lexer.nextToken();
         this.accept(Token.KEY);
         SQLPrimaryKeyImpl pk = new SQLPrimaryKeyImpl();
         this.accept(Token.LPAREN);
         this.exprParser.orderBy(pk.getColumns(), pk);
         this.accept(Token.RPAREN);
         return pk;
      } else {
         throw new ParserException("TODO " + this.lexer.info());
      }
   }
}
