package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;

public class Bin implements Function {
   public static final Bin instance = new Bin();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() != 1) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         param0.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         if (param0Value == null) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else if (param0Value instanceof Number) {
            long longValue = ((Number)param0Value).longValue();
            String result = Long.toString(longValue, 2);
            return result;
         } else {
            return SQLEvalVisitor.EVAL_ERROR;
         }
      }
   }
}
