package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;
import java.math.BigDecimal;

public class Char implements Function {
   public static final Char instance = new Char();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() == 0) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         StringBuffer buf = new StringBuffer(x.getArguments().size());

         for(SQLExpr param : x.getArguments()) {
            param.accept(visitor);
            Object paramValue = param.getAttributes().get("eval.value");
            if (paramValue instanceof Number) {
               int charCode = ((Number)paramValue).intValue();
               buf.append((char)charCode);
            } else {
               if (!(paramValue instanceof String)) {
                  return SQLEvalVisitor.EVAL_ERROR;
               }

               try {
                  int charCode = (new BigDecimal((String)paramValue)).intValue();
                  buf.append((char)charCode);
               } catch (NumberFormatException var8) {
               }
            }
         }

         return buf.toString();
      }
   }
}
