package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;

public class Elt implements Function {
   public static final Elt instance = new Elt();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() <= 1) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         param0.accept(visitor);
         Object param0Value = param0.getAttribute("eval.value");
         if (!(param0Value instanceof Number)) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else {
            int param0IntValue = ((Number)param0Value).intValue();
            if (param0IntValue >= x.getArguments().size()) {
               return SQLEvalVisitor.EVAL_VALUE_NULL;
            } else {
               SQLExpr item = (SQLExpr)x.getArguments().get(param0IntValue);
               item.accept(visitor);
               Object itemValue = item.getAttributes().get("eval.value");
               return itemValue;
            }
         }
      }
   }
}
