package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;

public class Instr implements Function {
   public static final Instr instance = new Instr();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() != 2) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         SQLExpr param1 = (SQLExpr)x.getArguments().get(1);
         param0.accept(visitor);
         param1.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         Object param1Value = param1.getAttributes().get("eval.value");
         if (param0Value != null && param1Value != null) {
            String strValue0 = param0Value.toString();
            String strValue1 = param1Value.toString();
            int result = strValue0.indexOf(strValue1) + 1;
            return result;
         } else {
            return SQLEvalVisitor.EVAL_ERROR;
         }
      }
   }
}
