package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.expr.SQLValuableExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;
import java.util.List;

public class Lcase implements Function {
   public static final Lcase instance = new Lcase();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() != 1) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         param0.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         if (param0Value == null) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else {
            String strValue = param0Value.toString();
            String result = strValue.toLowerCase();
            return result;
         }
      }
   }

   public Object eval(SQLMethodInvokeExpr x) {
      List<SQLExpr> arguments = x.getArguments();
      if (arguments.size() == 1) {
         Object p0 = ((SQLValuableExpr)arguments.get(0)).getValue();
         if (p0 instanceof String) {
            String str = (String)p0;
            return str.toLowerCase();
         }
      }

      return SQLEvalVisitor.EVAL_ERROR;
   }
}
