package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.expr.SQLValuableExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;
import java.util.List;

public class Ucase implements Function {
   public static final Ucase instance = new Ucase();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() != 1) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         param0.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         if (param0Value == null) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else {
            String strValue = param0Value.toString();
            String result = strValue.toUpperCase();
            return result;
         }
      }
   }

   public Object eval(SQLMethodInvokeExpr x) {
      List<SQLExpr> parameters = x.getArguments();
      if (parameters.size() == 1) {
         Object p0 = ((SQLValuableExpr)parameters.get(0)).getValue();
         if (p0 instanceof String) {
            String str = (String)p0;
            return str.toUpperCase();
         }
      }

      return SQLEvalVisitor.EVAL_ERROR;
   }
}
