package com.chenyang.druid.wall.spi;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlExportParameterVisitor;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.SQLStatementParser;
import com.chenyang.druid.sql.visitor.ExportParameterVisitor;
import com.chenyang.druid.wall.WallConfig;
import com.chenyang.druid.wall.WallProvider;
import com.chenyang.druid.wall.WallVisitor;

public class MySqlWallProvider extends WallProvider {
   public static final String DEFAULT_CONFIG_DIR = "META-INF/druid/wall/mysql";

   public MySqlWallProvider() {
      this(new WallConfig("META-INF/druid/wall/mysql"));
   }

   public MySqlWallProvider(WallConfig config) {
      super(config, DbType.mysql);
   }

   public SQLStatementParser createParser(String sql) {
      return new MySqlStatementParser(sql, new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup, SQLParserFeature.StrictForWall});
   }

   public WallVisitor createWallVisitor() {
      return new MySqlWallVisitor(this);
   }

   public ExportParameterVisitor createExportParameterVisitor() {
      return new MySqlExportParameterVisitor();
   }
}
