package com.palacesun.engine.spy.appender;

import com.palacesun.engine.logging.Category;

public abstract class FormattedLogger implements P6Logger {
   protected MessageFormattingStrategy strategy = new SingleLineFormat();

   protected FormattedLogger() {
   }

   public void logSQL(int connectionId, String now, long elapsed, Category category, String prepared, String sql, String url) {
      this.logText(this.strategy.formatMessage(connectionId, now, elapsed, category.toString(), prepared, sql, url));
   }

   public void setStrategy(MessageFormattingStrategy strategy) {
      this.strategy = strategy;
   }
}
